<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Admin;
use App\Models\Order;
use App\Models\Stock;
use App\Models\StudentPayment;
use Session;
use Image;
use Hash;
use Alert;

class AdminController extends Controller
{
    public function login(){
        return view('admin.auth.login');
    }
    public function home(){

        return view('admin.home');

    }
    public function admin_login(Request $request){
        $email = $request->email;
        $adminByEmail = Admin::where(['email'=>$email,'status'=>1])->first();
        
        if ($adminByEmail == null) {
            $notification=array(
                'message' => 'Email or Password is not Valid',
                'alert-type' => 'success'
            );
            return redirect()->back()->with('message', 'Email or Password is not Valid');
        } else {
            $existingPassword = $adminByEmail->password;
//    return $existingPassword;
            if (password_verify($request->password, $existingPassword)) {
                Session::put('adminId', $adminByEmail->id);
                Session::put('adminName', $adminByEmail->name);
                Session::put('adminEmail', $adminByEmail->email);
                Session::put('adminRole', $adminByEmail->role_id);
                return redirect('/admin/dashboard');
            } else {
                $notification=array(
                    'message' => 'Email or Password is not Valid',
                    'alert-type' => 'success'
                );
                return redirect()->back()->with($notification);
            }
        }
    }
    public function admin_logout(){
        Session::forget('adminId');
        Session::forget('adminName');
        Session::forget('adminEmail');

        return view('admin.auth.log_out');

        return redirect('/admin/login');
    }
    public function profile(){
        $id = Session::get('adminId');
        $user_by_id = Admin::where('id',$id)->first();
        return view('admin.auth.profile',compact('user_by_id'));
    }
    public function save_profile(Request $request){

        $id = Session::get('adminId');
        $data = Admin::where('id',$id)->first();
        $data->name=$request->name;
        $data->user_name=$request->username;
        $data->phone=$request->phone;
        $data->email=$request->email;
        $data->address=$request->address;
        
        if($request->hasFile('image')) {
            $image = $request->image;
            $filename = $image->getClientOriginalName();
            $filename = preg_replace('/\s+/', '-', $filename);
            $folder = 'uploads/'.date('Y').'/'.date('m');
            if (!file_exists($folder)) {
                mkdir($folder, 0777, true);
            }
            $user_img = $folder.'/'. time() . '-' . $filename;
            Image::make($image)->resize(300, 300)->save($user_img);
            $data->image = secure_asset($user_img);
        }
        
        $data->save();


        Alert::success('Successfully Updated', '');
        return redirect()->back();


        
    }
    public function change_password(){
        return view('admin.auth.change_pass');
    }
    public function save_password(Request $request){
        $id = Session::get('adminId');
        if($request->old_password){
            
            $this->validate($request, [
                'password' => 'min:6|required_with:password_confirmation|same:password_confirmation',
                'password_confirmation' => 'min:6'
            ]);
            $user = Admin::where('id',$id)->first();
            if (!(Hash::check($request->get('old_password'), $user->password))) {

                Alert::error('Your current password does not matches with the password you provided. Please try again', '');
                return redirect()->back();

           
            }
            $user->password = bcrypt($request->password);
            $user->save();


            Alert::success('Password Successfully Changed', '');
            return redirect()->back();
        

        }
    }

    public function lock_screen()
    {
        return view('admin.auth.lock_screen');
    }
}
