<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Banner;
use Illuminate\Http\Request;
Use Alert;


class BannerController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas = Banner::all();
        return view('admin.banner.index',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('admin.banner.create');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        
        $data = new Banner();
        $data->title = $request->title;
        $data->sub_title = $request->sub_title;
        $data->button_one_text = $request->button_one_text;
        $data->button_one_link = $request->button_one_link;
        $data->button_two_text = $request->button_two_text;
        $data->button_two_link = $request->button_two_link;

        $image = $request->file('image');
        if($image)
        {
            $image_name= time().'_'.$image->getClientOriginalName();
            $image_full_name = $image_name;
            $upload_path = 'images/banner_image/';
            $image_url = $upload_path.$image_full_name;
            $success = $image->move($upload_path, $image_full_name);
            if($success)
            {
                $data->image = $image_url;
            }
        }


        $data->status=$request->status;
        $data->save();

        Alert::success('Successfully done', '');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Banner::where('id',$id)->first();
        return view('admin.banner.edit',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {

        $data = Banner::find($id);
        $data->title = $request->title;
        $data->sub_title = $request->sub_title;
        $data->button_one_text = $request->button_one_text;
        $data->button_one_link = $request->button_one_link;
        $data->button_two_text = $request->button_two_text;
        $data->button_two_link = $request->button_two_link;

        $image = $request->file('image');

        if($image)
        {
            $image_name= time().'_'.$image->getClientOriginalName();
            $image_full_name = $image_name;
            $upload_path = 'images/banner_image/';
            $image_url = $upload_path.$image_full_name;
            $success = $image->move($upload_path, $image_full_name);
            if($success)
            {

                $old_image = $request->old_image;
                if (file_exists($old_image)) {
                    unlink($request->old_image);
                }

                $data->image = $image_url;
            }
        }



        $data->status=$request->status;
        $data->save();

        Alert::success('Successfully done', '');
        return redirect()->back();

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {

        $imagePath = Banner::select('image')->where('id', $id)->first();

        $filePath = $imagePath->image;

        if (file_exists($filePath)) {
            unlink($filePath);
            Banner::where('id', $id)->delete();
        }else{
            Banner::where('id', $id)->delete();
        }

        Alert::error('Successfully done', '');
        return redirect()->back();
    }





}
