<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Category;
use App\Models\Blog;
use Alert;

class BlogController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas = Blog::get();
        return view('admin.blog.index', compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $categories = Category::where('status', 1)->get();
        return view('admin.blog.create', compact('categories'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'category_id' => 'required',
            'title' => 'required|unique:blogs',
            'image' => 'required',
            'blog_description' => 'required',
            'status' => 'required',
        ]);

        $data = new Blog();
        $data->category_id = $request->category_id;
        $data->title = $request->title;
        $data->slug = $this->seo_slug($request->title);
        $data->blog_description = $request->blog_description;
        $data->meta_title = $request->meta_title;
        $data->meta_description = $request->meta_description;
        $data->meta_keywords = $request->meta_keywords;
        $data->status = $request->status;



        $image = $request->file('image');
        if($image)
        {
            $image_name= time().'_'.$image->getClientOriginalName();
            $image_full_name = $image_name;
            $upload_path = 'images/blog_image/';
            $image_url = $upload_path.$image_full_name;
            $success = $image->move($upload_path, $image_full_name);
            if($success)
            {
                $data->image = $image_url;
            }
        }

        $cover_image = $request->file('cover_image');
        if($cover_image)
        {
            $image_name= time().'_'.$cover_image->getClientOriginalName();
            $image_full_name = $image_name;
            $upload_path = 'images/blog_image/';
            $image_url = $upload_path.$image_full_name;
            $success = $cover_image->move($upload_path, $image_full_name);
            if($success)
            {
                $data->cover_image = $image_url;
            }
        }


        $data->save();


        Alert::success('Successfully done', '');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Blog::find($id);
        $categories = Category::where('status', 1)->get();

        return view('admin.blog.edit', compact('data', 'categories'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = Blog::find($id);
        $data->category_id = $request->category_id;
        $data->title = $request->title;
        $data->slug = $this->seo_slug($request->title);
        $data->blog_description = $request->blog_description;
        $data->meta_title = $request->meta_title;
        $data->meta_description = $request->meta_description;
        $data->meta_keywords = $request->meta_keywords;
        $data->status = $request->status;


        $image = $request->file('image');
        if($image)
        {
            $image_name= time().'_'.$image->getClientOriginalName();
            $image_full_name = $image_name;
            $upload_path = 'images/blog_image/';
            $image_url = $upload_path.$image_full_name;
            $success = $image->move($upload_path, $image_full_name);
            if($success)
            {

                $old_image = $request->old_image;
                if (file_exists($old_image)) {
                    unlink($request->old_image);
                }


                $data->image = $image_url;
            }
        }

        $cover_image = $request->file('cover_image');
        if($cover_image)
        {
            $image_name= time().'_'.$cover_image->getClientOriginalName();
            $image_full_name = $image_name;
            $upload_path = 'images/blog_image/';
            $image_url = $upload_path.$image_full_name;
            $success = $cover_image->move($upload_path, $image_full_name);
            if($success)
            {

                $old_cover_image = $request->old_cover_image;
                if (file_exists($old_cover_image)) {
                    unlink($request->old_cover_image);
                }


                $data->cover_image = $image_url;
            }
        }


        $data->save();
        

        Alert::success('Successfully done', '');
        return redirect()->back();
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $data = Blog::where('id', $id)->first();

        $filePath = $data->image;
        $coverFilePath = $data->cover_image;

        if (file_exists($filePath)) {
            unlink($filePath);
        }
        if (file_exists($coverFilePath)) {
            unlink($coverFilePath);
        }

        Blog::where('id', $id)->delete();

        Alert::error('Successfully done', '');
        return redirect()->back();
    }



    
    public function seo_slug($string)
    {
        
        $string=preg_replace('/[^A-Za-z0-9-]+/', '-', $string);
        $string=strtolower($string);
        return $string; 
    
    }
    

    
    public function img_slug($string)
    {
        
        $string=preg_replace('/[^A-Za-z0-9-]+/', '-', $string);
        $string=strtolower($string);
        return $string; 
    
    }
    
    
    public function non_seo_slug($string)
    {
        $string=str_replace(" ","-",$string);
        $string=strtolower($string);
        return $string; 
    
    }

}
