<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Continent;
use App\Models\Country;
use Illuminate\Http\Request;
Use Alert;


class CountryController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas = Country::all();

        $continents = Continent::get();

        return view('admin.country.index',compact('datas', 'continents'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $continents = Continent::get();
        return view('admin.country.create', compact('continents'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'continent_id' => 'required',
            'name' => 'required',
        ]);
        $data = new Country();
        $data->continent_id=$request->continent_id;
        $data->name=$request->name;
        $data->slug = $this->seo_slug($request->name);
        $data->status=$request->status;


        $image = $request->file('image');
        if($image)
        {
            $image_name= time().'_'.$image->getClientOriginalName();
            $image_full_name = $image_name;
            $upload_path = 'images/country_flag/';
            $image_url = $upload_path.$image_full_name;
            $success = $image->move($upload_path, $image_full_name);
            if($success)
            {
                $data->image = $image_url;
            }
        }


        $tour_page_cover_image = $request->file('tour_page_cover_image');
        if($tour_page_cover_image)
        {
            $image_name= time().'_'.$tour_page_cover_image->getClientOriginalName();
            $image_full_name = $image_name;
            $upload_path = 'images/country_cover_image/';
            $image_url = $upload_path.$image_full_name;
            $success = $tour_page_cover_image->move($upload_path, $image_full_name);
            if($success)
            {
                $data->tour_page_cover_image = $image_url;
            }
        }


        $data->save();

        Alert::success('Successfully done', '');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = Country::where('id',$id)->first();
        $continents = Continent::get();
        return view('admin.country.edit',compact('data', 'continents'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validatedData = $request->validate([
            'continent_id' => 'required',
            'name' => 'required',
        ]);
        $data = Country::find($id);
        $data->continent_id=$request->continent_id;
        $data->name=$request->name;
        $data->slug = $this->seo_slug($request->name);
        $data->status=$request->status;


        $image = $request->file('image');
        if($image)
        {
            $image_name= time().'_'.$image->getClientOriginalName();
            $image_full_name = $image_name;
            $upload_path = 'images/country_flag/';
            $image_url = $upload_path.$image_full_name;
            $success = $image->move($upload_path, $image_full_name);
            if($success)
            {

                $old_image = $request->old_image;
                if (file_exists($old_image)) {
                    unlink($request->old_image);
                }

                $data->image = $image_url;
            }
        }



        $tour_page_cover_image = $request->file('tour_page_cover_image');
        if($tour_page_cover_image)
        {
            $image_name= time().'_'.$tour_page_cover_image->getClientOriginalName();
            $image_full_name = $image_name;
            $upload_path = 'images/country_cover_image/';
            $image_url = $upload_path.$image_full_name;
            $success = $tour_page_cover_image->move($upload_path, $image_full_name);
            if($success)
            {

                $old_tour_page_cover_image = $request->old_tour_page_cover_image;
                if (file_exists($old_tour_page_cover_image)) {
                    unlink($request->old_tour_page_cover_image);
                }

                $data->tour_page_cover_image = $image_url;
            }
        }

        $data->save();

        Alert::success('Successfully done', '');
        return redirect()->back();

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $image = Country::where('id', $id)->first();

        $filePath = $image->image;
        $tour_page_cover_image = $image->tour_page_cover_image;

        if (file_exists($filePath)) {
            unlink($filePath);

        }
        
        if (file_exists($tour_page_cover_image)) {
            unlink($tour_page_cover_image);

        }

        Country::where('id', $id)->delete();

        Alert::error('Successfully done', '');
        return redirect()->back();
    }


    
    public function seo_slug($string)
    {
        
        $string=preg_replace('/[^A-Za-z0-9-]+/', '-', $string);
        $string=strtolower($string);
        return $string; 
    
    }
    

    
    public function img_slug($string)
    {
        
        $string=preg_replace('/[^A-Za-z0-9-]+/', '-', $string);
        $string=strtolower($string);
        return $string; 
    
    }
    
    
    public function non_seo_slug($string)
    {
        $string=str_replace(" ","-",$string);
        $string=strtolower($string);
        return $string; 
    
    }


}
