<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\HomePageSetting;
use Alert;

class HomePageSettingController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $data = HomePageSetting::first();
        return view('admin.home_page_settings.index', compact('data'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $home_page = HomePageSetting::first();

        if($home_page){

            $data = HomePageSetting::find($home_page->id);
            $data->home_page_about_section = $request->home_page_about_section;
            $data->home_page_umrah_section = $request->home_page_umrah_section;
            $data->home_page_tour_section = $request->home_page_tour_section;
            $data->home_page_visa_section = $request->home_page_visa_section;
            
            $data->home_page_choose_us_des_one_section = $request->home_page_choose_us_des_one_section;
            $data->home_page_choose_us_des_two_section = $request->home_page_choose_us_des_two_section;


            $data->home_page_video_code_one = $request->home_page_video_code_one;
            $data->home_page_video_code_two = $request->home_page_video_code_two;
            $data->home_page_mission_and_vision_section = $request->home_page_mission_and_vision_section;



            $home_page_umrah_section_bg_image = $request->file('home_page_umrah_section_bg_image');

            if($home_page_umrah_section_bg_image)
            {
                $image_name= time().'_'.$home_page_umrah_section_bg_image->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/home_page_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $home_page_umrah_section_bg_image->move($upload_path, $image_full_name);
                if($success)
                {

                    $old_home_page_umrah_section_bg_image = $request->old_home_page_umrah_section_bg_image;
                    if (file_exists($old_home_page_umrah_section_bg_image)) {
                        unlink($request->old_home_page_umrah_section_bg_image);
                    }

                    $data->home_page_umrah_section_bg_image = $image_url;
                }
            }



            $home_page_visa_section_bg_image = $request->file('home_page_visa_section_bg_image');
            if($home_page_visa_section_bg_image)
            {
                $image_name= time().'_'.$home_page_visa_section_bg_image->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/home_page_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $home_page_visa_section_bg_image->move($upload_path, $image_full_name);
                if($success)
                {

                    $old_home_page_visa_section_bg_image = $request->old_home_page_visa_section_bg_image;
                    if (file_exists($old_home_page_visa_section_bg_image)) {
                        unlink($request->old_home_page_visa_section_bg_image);
                    }

                    $data->home_page_visa_section_bg_image = $image_url;
                }
            }



            $home_page_why_choose_section_bg_image = $request->file('home_page_why_choose_section_bg_image');
            if($home_page_why_choose_section_bg_image)
            {
                $image_name= time().'_'.$home_page_why_choose_section_bg_image->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/home_page_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $home_page_why_choose_section_bg_image->move($upload_path, $image_full_name);
                if($success)
                {

                    $old_home_page_why_choose_section_bg_image = $request->old_home_page_why_choose_section_bg_image;
                    if (file_exists($old_home_page_why_choose_section_bg_image)) {
                        unlink($request->old_home_page_why_choose_section_bg_image);
                    }

                    $data->home_page_why_choose_section_bg_image = $image_url;
                }
            }



            $data->save();

        }else{

            $data = new HomePageSetting();
            $data->home_page_about_section = $request->home_page_about_section;
            $data->home_page_umrah_section = $request->home_page_umrah_section;
            $data->home_page_tour_section = $request->home_page_tour_section;
            $data->home_page_visa_section = $request->home_page_visa_section;

            $data->home_page_choose_us_des_one_section = $request->home_page_choose_us_des_one_section;
            $data->home_page_choose_us_des_two_section = $request->home_page_choose_us_des_two_section;


            $data->home_page_video_code_one = $request->home_page_video_code_one;
            $data->home_page_video_code_two = $request->home_page_video_code_two;
            $data->home_page_mission_and_vision_section = $request->home_page_mission_and_vision_section;


            $home_page_umrah_section_bg_image = $request->file('home_page_umrah_section_bg_image');
            if($home_page_umrah_section_bg_image)
            {
                $image_name= time().'_'.$home_page_umrah_section_bg_image->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/home_page_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $home_page_umrah_section_bg_image->move($upload_path, $image_full_name);
                if($success)
                {
                    $data->home_page_umrah_section_bg_image = $image_url;
                }
            }


            $home_page_visa_section_bg_image = $request->file('home_page_visa_section_bg_image');
            if($home_page_visa_section_bg_image)
            {
                $image_name= time().'_'.$home_page_visa_section_bg_image->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/home_page_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $home_page_visa_section_bg_image->move($upload_path, $image_full_name);
                if($success)
                {
                    $data->home_page_visa_section_bg_image = $image_url;
                }
            }



            $home_page_why_choose_section_bg_image = $request->file('home_page_why_choose_section_bg_image');
            if($home_page_why_choose_section_bg_image)
            {
                $image_name= time().'_'.$home_page_why_choose_section_bg_image->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/home_page_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $home_page_why_choose_section_bg_image->move($upload_path, $image_full_name);
                if($success)
                {
                    $data->home_page_why_choose_section_bg_image = $image_url;
                }
            }

            
            $data->save();

        }

        Alert::success('Successfully done', '');
        return redirect()->back();
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
