<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Continent;
use App\Models\VisaService;
use App\Models\VisaServiceImage;
use App\Models\Country;
use Alert;

class VisaServiceController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $datas = VisaService::orderBy('id', 'desc')->get();
        return view('admin.visa_service.index', compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $continents = Continent::where('status', 1)->get();
        return view('admin.visa_service.create', compact('continents'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'continent_id' => 'required',
            'country_id' => 'required',
            'title' => 'required',
        ]);

        $data = new VisaService();
        $data->continent_id = $request->continent_id;
        $data->country_id = $request->country_id;
        $data->title = $request->title;
        $data->slug = $this->seo_slug($request->title);
        $data->visa_details = $request->visa_details;
        $data->visa_other_information = $request->visa_other_information;
        $data->visa_faq = $request->visa_faq;
        $data->best_visa_service_for = $request->best_visa_service_for;
        $data->meta_title = $request->meta_title;
        $data->meta_description = $request->meta_description;
        $data->meta_keywords = $request->meta_keywords;

        $meta_image = $request->file('meta_image');
        if($meta_image)
        {
            $image_name= time().'_'.$meta_image->getClientOriginalName();
            $image_full_name = $image_name;
            $upload_path = 'images/visa_service_meta_image/';
            $image_url = $upload_path.$image_full_name;
            $success = $meta_image->move($upload_path, $image_full_name);
            if($success)
            {
                $data->meta_image = $image_url;
            }
        }

        $data->status = $request->status;
        $data->save();

        $file = $request->file('image');

        if($file){

            foreach ($file as $key => $value ){
                $visa_image = new VisaServiceImage();
                $image_name=time().$data->id.'_'.$value->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/visa_service_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $value->move($upload_path, $image_full_name);
                $visa_image->visa_service_id = $data->id;
                $visa_image->image = $image_url;
                $visa_image->save();
            }

        }


        Alert::success('Successfully done', '');
        return redirect()->back();
        
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {

        $data = VisaService::find($id);
        $visa_service_images = VisaServiceImage::where('visa_service_id', $id)->get();

        $continents = Continent::where('status', 1)->get();
        $countries = Country::where('continent_id', $data->continent_id)->where('status', 1)->get();

        return view('admin.visa_service.edit', compact('continents', 'data', 'visa_service_images', 'countries'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = VisaService::find($id);
        $data->continent_id = $request->continent_id;
        $data->country_id = $request->country_id;
        $data->title = $request->title;
        $data->slug = $this->seo_slug($request->title);
        $data->visa_details = $request->visa_details;
        $data->visa_other_information = $request->visa_other_information;
        $data->visa_faq = $request->visa_faq;
        $data->best_visa_service_for = $request->best_visa_service_for;
        $data->meta_title = $request->meta_title;
        $data->meta_description = $request->meta_description;
        $data->meta_keywords = $request->meta_keywords;

        $meta_image = $request->file('meta_image');
        if($meta_image)
        {
            $image_name= time().'_'.$meta_image->getClientOriginalName();
            $image_full_name = $image_name;
            $upload_path = 'images/visa_service_meta_image/';
            $image_url = $upload_path.$image_full_name;
            $success = $meta_image->move($upload_path, $image_full_name);
            if($success)
            {

                $old_meta_image = $request->old_meta_image;
                if (file_exists($old_meta_image)) {
                    unlink($request->old_meta_image);
                }


                $data->meta_image = $image_url;
            }
        }

        $data->status = $request->status;
        $data->save();

        $file = $request->file('image');


        if($file){

            $visa_service_images = VisaServiceImage::select('image')->where('visa_service_id', $id)->get();
            foreach ($visa_service_images as $key => $value) {
                unlink($value->image);
            }

            foreach ($file as $key => $value ){

                $visa_image = new VisaServiceImage();
                $image_name=time().$data->id.'_'.$value->getClientOriginalName();
                $image_full_name = $image_name;
                $upload_path = 'images/visa_service_image/';
                $image_url = $upload_path.$image_full_name;
                $success = $value->move($upload_path, $image_full_name);
                $visa_image->visa_service_id = $data->id;
                $visa_image->image = $image_url;
                $visa_image->save();

            }

        }


        Alert::success('Successfully done', '');
        return redirect()->back();
        
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $visa_service = VisaService::where('id', $id)->first();

        $filePath = $visa_service->image;

        if (file_exists($filePath)) {
            unlink($filePath);
        }


        $visa_service_images = VisaServiceImage::select('image')->where('visa_service_id', $id)->get();

        if(count($visa_service_images) > 0){

            foreach ($visa_service_images as $key => $value) {
                unlink($value->image);
            }

        }


        VisaService::where('id', $id)->delete();

        Alert::error('Successfully done', '');
        return redirect()->back();
    }

    public function delete_visa_service_image($id)
    {
        $imagePath = VisaServiceImage::select('image')->where('id', $id)->first();

        $filePath = $imagePath->image;

        if (file_exists($filePath)) {
            unlink($filePath);
        }

        VisaServiceImage::where('id', $id)->delete();

        Alert::error('Successfully done', '');
        return redirect()->back();
    }


    public function seo_slug($string)
    {
        
        $string=preg_replace('/[^A-Za-z0-9-]+/', '-', $string);
        $string=strtolower($string);
        return $string; 
    
    }
    

    
    public function img_slug($string)
    {
        
        $string=preg_replace('/[^A-Za-z0-9-]+/', '-', $string);
        $string=strtolower($string);
        return $string; 
    
    }
    
    
    public function non_seo_slug($string)
    {
        $string=str_replace(" ","-",$string);
        $string=strtolower($string);
        return $string; 
    
    }

}
