<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\UserAddress;
use App\Models\UserEducation;
use App\Models\ApplicationForm;
use App\Models\AgentBonusHistory;
use App\Models\Withdraw;
use App\Models\WithdrawHistory;
use App\Models\SiteImage;
use App\Models\SMSAPI;
use App\Models\WebsiteInformation;
use App\Models\Course;
use App\Models\StudentCourse;
use App\Models\StudentPayment;
use App\Models\Level;
use App\Models\Subject;
use App\Models\Classes;
use App\Models\Exam;
use App\Models\StudentExam;
use Auth;
use Hash;
use Str;
use Alert;
use DB;
use Carbon\Carbon;
use shurjopayv2\ShurjopayLaravelPackage8\Http\Controllers\ShurjopayController;

class UserController extends Controller
{


    public function dashboard()
    {
        $user = Auth::user();

        $site_info = WebsiteInformation::first();

        $courses = StudentCourse::where('user_id', $user->id)->orderBy('id', 'desc')->get();

        return view('frontend.user.dashboard', compact('user', 'site_info', 'courses'));
    }    

    public function change_password()
    {
        $user = Auth::user();

        $site_info = WebsiteInformation::first();
        return view('frontend.user.change_password', compact('user', 'site_info'));
    }  

    public function update_password(Request $request)
    {

        $this->validate($request,[
            'old_password' => 'required',
            'password' => 'required|confirmed|min:6',
        ]);

        $user = Auth::user();
        $site_info = WebsiteInformation::first();

        $old_password = $request->old_password;
        $password = $request->password;
        $password_confirmation = $request->password_confirmation;

        $user = User::where('id', $user->id)->where('password_str', $old_password)->first();

        if(!$user){
            return back()->with('error','Old password does not match !');
        }

        User::where('id', $user->id)->update([
            'password' => Hash::make($request->password),
            'password_str' => $request->password,
        ]);

        return back()->with('success','Password update successful.');

    }

    public function forgot_password()
    {

        $site_info = WebsiteInformation::first();
        return view('frontend.user.forgot_password', compact('site_info'));
    }

    public function send_otp(Request $request)
    {

        $phone_number = $request->phone_number;
        $user = User::where('phone_number', $phone_number)->first();

        if($phone_number && $user){


            $sms_api = SMSAPI::first();

            $otp = rand(1111, 9999).$user->id;
         

            $apiKey= $sms_api->api_key; 
            $sender_id= $sms_api->sender_id; 
            $user_email = $sms_api->user_email;
            $mobile_no = $phone_number.',';


            $message = 'Your OTP Code is :'.' '.$otp;


            $url = $sms_api->api_url;
            $data = array('api_key' => $apiKey,
                    'sender_id' => $sender_id,
                'message' => $message,
                'mobile_no' =>$mobile_no,
                'user_email'=> $user_email   
            );


           $curl = curl_init($url);
            curl_setopt($curl, CURLOPT_POST, true);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);
            curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, false);     
            $output = curl_exec($curl);
            curl_close($curl);

            User::where('id', $user->id)->update([
                'forgot_pass_otp' => $otp
            ]);


            return redirect()->route('user.verify', ['phone_number' => $phone_number]);

            // $site_info = WebsiteInformation::first();
            // return view('frontend.user.send_otp', compact('site_info'));

        }else{

            Alert::error('Phone number not found!', '');
            return redirect()->back();
        }

    }

    public function verify($phone_number)
    {

        $site_info = WebsiteInformation::first();
        $user = User::where('phone_number', $phone_number)->first();


        return view('frontend.user.verify_otp', compact('site_info', 'phone_number'));

    }

    public function verify_otp(Request $request)
    {

        $site_info = WebsiteInformation::first();

        $forgot_pass_otp = $request->forgot_pass_otp;
        $phone_number = $request->phone_number;

        $user = User::where('forgot_pass_otp', $forgot_pass_otp)->where('phone_number', $phone_number)->first();
        if(!$user){

            Alert::error('OTP code in invalid !', '');
            return redirect()->back();

        }

        User::where('id', $user->id)->update([
            'forgot_pass_otp' => null,
            'status' => 1
        ]);

        return redirect()->route('user.reset-password', ['phone_number' => $phone_number]);

    }

    public function reset_password($phone_number)
    {
        $site_info = WebsiteInformation::first();
        $user = User::where('phone_number', $phone_number)->first();

        return view('frontend.user.reset_password', compact('site_info', 'phone_number'));
    }

    public function final_update_password(Request $request)
    {

        $this->validate($request,[
            'password' => 'required|confirmed|min:6',
        ]);

        $user = User::where('phone_number', $request->phone_number)->first();
        $site_info = WebsiteInformation::first();

        User::where('id', $user->id)->update([
            'password' => Hash::make($request->password),
            'password_str' => $request->password,
        ]);

        return redirect()->route('user.password-update-successful');


    }

    public function password_update_successful()
    {
        
        $site_info = WebsiteInformation::first();
        return view('frontend.user.password_update_successful', compact('site_info'));

    }


    
    public function profile()
    {
        $user = Auth::user();

        $site_info = WebsiteInformation::first();
        return view('frontend.user.profile', compact('user', 'site_info'));
    }
    
    public function update_profile(Request $request)
    {
        $user = Auth::user();

        $user = User::find($user->id);
        $user->name = $request->name;
        $user->gender = $request->gender;
        $user->religion = $request->religion;
        $user->email = $request->email;
        $user->blood_group = $request->blood_group;
        $user->date_of_birth = $request->date_of_birth;
        $user->father_name = $request->father_name;
        $user->mother_name = $request->mother_name;
        $user->father_phone = $request->father_phone;
        $user->mother_phone = $request->mother_phone;
        $user->save();

        return back()->with('success','Profile information updated successful.');

    }

    public function update_profile_image(Request $request)
    {

        $user = Auth::user();


        $data = User::find($user->id);

        $image = $request->file('image');

        if($image)
        {
            $image_name= time().'_'.$image->getClientOriginalName();
            $image_full_name = $image_name;
            $upload_path = 'images/student_profile_image/';
            $image_url = $upload_path.$image_full_name;
            $success = $image->move($upload_path, $image_full_name);
            if($success)
            {


                $old_image = $request->old_image;
                if (file_exists($old_image)) {
                    unlink($request->old_image);
                }

                $data->image = $image_url;
            }
        }
        $data->save();

        return back()->with('success','Profile image updated successful.');

    }

    public function pay_now($id)
    {

        $user = Auth::user();

        if(!$user){
            Alert::warning('Please Login First', '');
            return redirect()->back();
        }

        $course = Course::where('id', $id)->first();
        $already_buy = StudentCourse::where('user_id', $user->id)->where('course_id', $course->id)->first();

        if($already_buy){
            Alert::error('You already purchase this course!', '');
            return redirect()->back();
        }

        if($course->discount_price == 0 && $course->regular_price == 0 && $course->isPaid == 0){

            $data = new StudentCourse();
            $data->user_id = $user->id;
            $data->course_id = $course->id;
            $data->status = 1;
            $data->save();

            $payment = new StudentPayment();
            $payment->user_id = $user->id;
            $payment->course_id = $course->id;
            $payment->amount = 0;
            $payment->order_id = null;
            $payment->currency = 'BDT';
            $payment->phone_no = $user->phone_number;
            $payment->bank_trx_id = 'Free Course';
            $payment->bank_status = 'Success';
            $payment->customer_order_id = null;
            $payment->sp_code = null;
            $payment->method = null;
            $payment->date_time = Carbon::now();
            $payment->status = 1;
            $payment->save();

            Alert::success('Success!', 'Successfully enrolled this course.');
            return redirect('/dashboard/');

        }else{


            $price = 0;
            if($course->discount_price != 0){
                $price = $course->discount_price;
            }elseif($course->regular_price != 0){
                $price = $course->regular_price;
            }else{
                $price = 0;
            }

            $info = array( 
                  'currency' => "BDT", 
                  'amount' => $price, 
                  'order_id' => uniqid(),
                  'discsount_amount' => 0, 
                  'disc_percent' => 0, 
                  'client_ip' => "127:0:1:0", 
                  'customer_name' => $user->name, 
                  'customer_phone' => $user->phone_number,
                  'email' => 'student@gmail.com',
                  'customer_address' => 'Bangladesh',
                  'customer_city' => 'NA', 
                  'customer_state' => 'NA', 
                  'customer_postcode' => "0000", 
                  'customer_country' => "Bangladesh",
                  'tran_id' => uniqid(), 
                  'value1' => $course->id, 
              );

           $shurjopay_service = new ShurjopayController(); 
           return $shurjopay_service->checkout($info);


        }

    }

    public function verifyPayemnt(Request $request)
    {

        $order_id = $request->order_id;
        $shurjopay_service = new ShurjopayController(); 
        $data = $shurjopay_service->verify($order_id);
        
        $response = json_decode($data);

        $user = Auth::user();
        
        if($response[0]->sp_code != 1000){
            return redirect('/cancel-url');
        }else{

            $data = new StudentCourse();
            $data->user_id = $user->id;
            $data->course_id = $response[0]->value1;
            $data->status = 1;
            $data->save();

            $payment = new StudentPayment();
            $payment->user_id = $user->id;
            $payment->course_id = $response[0]->value1;
            $payment->amount = $response[0]->amount;
            $payment->order_id = $response[0]->order_id;
            $payment->currency = $response[0]->currency;
            $payment->phone_no = $response[0]->phone_no;
            $payment->bank_trx_id = $response[0]->bank_trx_id;
            $payment->bank_status = $response[0]->bank_status;
            $payment->customer_order_id = $response[0]->customer_order_id;
            $payment->sp_code = $response[0]->sp_code;
            $payment->method = $response[0]->method;
            $payment->date_time = $response[0]->date_time;
            $payment->status = 1;
            $payment->save();

            Alert::success('Success!', ' Thanks for purchasing the course ');
            return redirect('/dashboard/');

        }

    }


    public function cancelPayemnt()
    {
        return redirect('/');
    }



    public function my_courses()
    {
        $user = Auth::user();
        $site_info = WebsiteInformation::first();

        if(!$user){
            Alert::warning('Please Login First', '');
            return redirect()->back();
        }

        $courses = StudentCourse::where('user_id', $user->id)->orderBy('id', 'desc')->get();
        $levels = Level::where('status', 1)->get();

        return view('frontend.user.my_courses', compact('courses', 'site_info', 'levels'));

    }



    public function my_routine()
    {
        $user = Auth::user();
        $site_info = WebsiteInformation::first();

        if(!$user){
            Alert::warning('Please Login First', '');
            return redirect()->back();
        }

        $courses = StudentCourse::where('user_id', $user->id)->orderBy('id', 'desc')->get();
        $levels = Level::where('status', 1)->get();
        $subjects = Subject::where('status', 1)->get();

        $courseIds = DB::table('student_courses')->select('course_id')->where('user_id', $user->id)->pluck('course_id');
        $classIds = DB::table('classes')->select('id')->whereIn('course_id', $courseIds)->pluck('id');
        $classes =  Classes::whereIn('id', $classIds)->get();

        // Get the class IDs for the purchased courses
        $examIds = DB::table('exams') ->select('id')->whereIn('course_id', $courseIds) ->pluck('id');

        // Retrieve the class details
        $exams = Exam::whereIn('id', $examIds)->get();


        return view('frontend.user.my_routine', compact('courses', 'site_info', 'levels', 'subjects', 'courseIds', 'classIds', 'classes', 'user', 'examIds', 'exams'));

    }

    public function prerecordedvideo($id, $slug)
    {
        $class = Classes::where('id', $id)->where('slug', $slug)->first();
        return view('frontend.user.prerecordedvideo', compact('class'));
    }


    public function buy_more_course()
    {
        $user = Auth::user();
        $site_info = WebsiteInformation::first();

        if(!$user){
            Alert::warning('Please Login First', '');
            return redirect()->back();
        }

        $courses = Course::orderBy('id', 'desc')->get();
        $levels = Level::where('status', 1)->get();

        return view('frontend.user.buy_more_course', compact('courses', 'site_info', 'levels', 'user'));

    }

    public function payment_history()
    {
        $user = Auth::user();
        $site_info = WebsiteInformation::first();

        if(!$user){
            Alert::warning('Please Login First', '');
            return redirect()->back();
        }

        $payment_histories = StudentPayment::where('user_id', $user->id)->orderBy('id', 'desc')->get();
        return view('frontend.user.payment_history', compact('payment_histories', 'site_info'));

    }

    public function past_exam()
    {
        $user = Auth::user();
        $site_info = WebsiteInformation::first();

        $courses = StudentCourse::where('user_id', $user->id)->orderBy('id', 'desc')->get();


        $past_exams = StudentExam::where('student_id', $user->id)->orderBy('id', 'desc')->get();


        return view('frontend.user.past_exam', compact('site_info', 'past_exams', 'user', 'courses'));

    }




}
