<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateVisaServicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('visa_services', function (Blueprint $table) {
            $table->id();
            $table->integer('continent_id');
            $table->integer('country_id');
            $table->text('title');
            $table->text('slug');
            $table->longText('visa_details')->nullable();
            $table->longText('visa_other_information')->nullable();
            $table->longText('visa_faq')->nullable();
            $table->longText('best_visa_service_for')->nullable();
            $table->text('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->text('meta_keywords')->nullable();
            $table->text('meta_image')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('visa_services');
    }
}
