<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUmrahServicesTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('umrah_services', function (Blueprint $table) {
            $table->id();
            $table->integer('continent_id');
            $table->text('title');
            $table->text('slug');
            $table->integer('price_start_per_person');
            $table->longText('umrah_details')->nullable();
            $table->longText('umrah_other_information')->nullable();
            $table->longText('umrah_faq')->nullable();
            $table->longText('umrah_remark')->nullable();
            $table->longText('umrah_itinerary')->nullable();
            $table->longText('best_umrah_service_for')->nullable();
            $table->text('meta_title')->nullable();
            $table->text('meta_description')->nullable();
            $table->text('meta_keywords')->nullable();
            $table->text('meta_image')->nullable();
            $table->boolean('status')->default(1);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('umrah_services');
    }
}
