@extends('admin.layouts.app')

@section('head')
<title> Password | {{ config('app.name') }}  </title>
<meta name="csrf-token" content="{{csrf_token()}}">
@endsection

@section('content')


    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Password</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Password</a></li>
                                    <li class="breadcrumb-item active">List View</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div id="instructorList">


                    <div class="row">
                        <div class="col-lg-2"></div>
                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row align-items-center g-2">
                                        <div class="col-lg-3 me-auto">
                                            <h6 class="card-title mb-0">Update Password </h6>
                                        </div><!--end col-->
                             
                                        <div class="col-sm-auto">
                                            <div class="hstack gap-2">

                                                <a href="{{ url()->previous() }}" class="btn btn-secondary"><i class="bi bi-arrow-left-circle align-baseline me-1"></i> Back </a>
                                            </div>
                                        </div><!--end col-->
                                    </div>
                                </div>
                                <div class="card-body mt-3">

                                    @if ($errors->any())

                                        <div class="alert alert-danger">

                                            <ul>

                                                @foreach ($errors->all() as $error)

                                                    <li>{{ $error }}</li>

                                                @endforeach

                                            </ul>

                                        </div>

                                    @endif

                                    <form role="form" action="{{route('save-password')}}" method="post">
                                        @csrf
                                        <div class="card-body">
                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Old Password</label>
                                                <input type="password" name="old_password" class="form-control" id="exampleInputEmail1" placeholder="Old Password">
                                            </div>
                                            <br>

                                            <div class="form-group">
                                                <label for="exampleInputEmail1">New Password</label>
                                                <input type="password" name="password" class="form-control" id="exampleInputEmail1" placeholder="New Password">
                                            </div>

                                              <br>
                                              
                                            <div class="form-group">
                                                <label for="exampleInputEmail1">Confirm Password</label>
                                                <input type="password" name="password_confirmation" class="form-control" id="exampleInputEmail1" placeholder="Confirm Password">
                                            </div>


                                        </div>
                                        <!-- /.card-body -->

                                        <div class="card-footer">
                                            <button type="submit" class="btn btn-primary">Submit</button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div><!--end col-->
                        <div class="col-lg-2"></div>
                    </div><!--end row-->


                </div>

            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->

    </div>



@stop