@extends('admin.layouts.app')

@section('head')
<title> Admin Profile | {{ config('app.name') }}  </title>
<meta name="csrf-token" content="{{csrf_token()}}">
@endsection

@section('content')


    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Profile</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Profile</a></li>
                                    <li class="breadcrumb-item active">List View</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div id="instructorList">


                    <div class="row">
                        <div class="col-lg-2"></div>
                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row align-items-center g-2">
                                        <div class="col-lg-3 me-auto">
                                            <h6 class="card-title mb-0">Edit Profile </h6>
                                        </div><!--end col-->
                             
                                        <div class="col-sm-auto">
                                            <div class="hstack gap-2">

                                                <a href="{{ url()->previous() }}" class="btn btn-secondary"><i class="bi bi-arrow-left-circle align-baseline me-1"></i> Back </a>
                                            </div>
                                        </div><!--end col-->
                                    </div>
                                </div>
                                <div class="card-body mt-3">

	                                @if ($errors->any())

	                                    <div class="alert alert-danger">

	                                        <ul>

	                                            @foreach ($errors->all() as $error)

	                                                <li>{{ $error }}</li>

	                                            @endforeach

	                                        </ul>

	                                    </div>

	                                @endif


					              <form action="#" method="post" enctype="multipart/form-data">
			                        @csrf
					                <div class="card-body">
					                  <div class="form-group row">
					                    <label for="inputEmail3" class="col-sm-3 col-form-label">Name</label>
					                    <div class="col-sm-9">
			                            <input type="text" class="form-control" value="{{$user_by_id->name ?? ''}}" name="name" placeholder="First Name">
			                            
					                    </div>
					                  </div>	
					                  <br>	                  
					                  <div class="form-group row">
					                    <label for="inputEmail3" class="col-sm-3 col-form-label">User Name</label>
					                    <div class="col-sm-9">
					                      <input type="text" class="form-control" value="{{$user_by_id->user_name ?? ''}}" name="username" placeholder="User Name">				
					                    </div>
					                  </div>	
					                  <br>	  	                  	                  
					                  <div class="form-group row">
					                    <label for="inputEmail3" class="col-sm-3 col-form-label">Phone Number</label>
					                    <div class="col-sm-9">
					                      <input type="number" class="form-control" value="{{$user_by_id->phone ?? ''}}" name="phone" placeholder="Phone Number">				
					                    </div>
					                  </div>		                  
					                  <br>	  
					                  <div class="form-group row">
					                    <label for="inputEmail3" class="col-sm-3 col-form-label">Email</label>
					                    <div class="col-sm-9">
					                      <input type="email" class="form-control" value="{{$user_by_id->email ?? ''}}" name="email" placeholder="Email">				
					                    </div>
					                  </div>		                  
					                  <br>	  
					                  <div class="form-group row">
					                    <label for="inputEmail3" class="col-sm-3 col-form-label">Address</label>
					                    <div class="col-sm-9">
					                      <input type="text" class="form-control" value="{{$user_by_id->address ?? ''}}" name="address" placeholder="Address">				
					                    </div>
					                  </div>		                  
					                  <br>	  
					                
					                </div>
					                <!-- /.card-body -->
					                <div class="card-footer">
					                  <button type="submit" class="btn btn-info">Update</button>
					                </div>
					                <!-- /.card-footer -->
					              </form>
                                </div>
                            </div>
                        </div><!--end col-->
                        <div class="col-lg-2"></div>
                    </div><!--end row-->


                </div>

            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->

    </div>



@stop