@extends('admin.layouts.app')

@section('head')
<title> Edit Guest Request | {{ config('app.name') }}  </title>
<meta name="csrf-token" content="{{csrf_token()}}">
@endsection

@section('content')


    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">Guest Request</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">Guest Request</a></li>
                                    <li class="breadcrumb-item active">List View</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div id="instructorList">


                    <div class="row">
                        <div class="col-lg-2"></div>
                        <div class="col-lg-8">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row align-items-center g-2">
                                        <div class="col-lg-3 me-auto">
                                            <h6 class="card-title mb-0">Edit Request </h6>
                                        </div><!--end col-->
                             
                                        <div class="col-sm-auto">
                                            <div class="hstack gap-2">

                                                <a href="{{ url()->previous() }}" class="btn btn-secondary"><i class="bi bi-arrow-left-circle align-baseline me-1"></i> Back </a>
                                            </div>
                                        </div><!--end col-->
                                    </div>
                                </div>
                                <div class="card-body mt-3">

	                                @if ($errors->any())

	                                    <div class="alert alert-danger">

	                                        <ul>

	                                            @foreach ($errors->all() as $error)

	                                                <li>{{ $error }}</li>

	                                            @endforeach

	                                        </ul>

	                                    </div>

	                                @endif


                                        <form action="{{route('guest_request.update',$data->id)}}" method="post" enctype="multipart/form-data">
                                            @method('patch')
                                            @csrf
                        
                    


                                            <div class="modal-body">
                                                <div id="alert-error-msg" class="d-none alert alert-danger py-2"></div>
                                                <input type="hidden" id="id-field">
                                                <input type="hidden" id="rating-field">
                                              
                            
                                                <div class="row">
                                                    

                                                    <div class="col-lg-12">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Type<span class="text-danger">*</span></label>
                                                            <input type="text" id="instructor-name-input" name="" value="{{ $data->type }}" class="form-control" placeholder="" readonly style="background: #d7d7d7;">
                                                        </div>
                                                    </div>


                                                    <div class="col-lg-6">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Want to go<span class="text-danger">*</span></label>
                                                            <select class="form-control" name="want_to_go_country_id" required>

                                                                @foreach($countries as $item)
                                                                <option value="{{$item->id}}" @php if ($item->id == $data->want_to_go_country_id) { echo "selected"; } @endphp>{{$item->name}}</option>
                                                                @endforeach

                                                            </select>
                                                        </div>
                                                    </div>


                                                    <div class="col-lg-6">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Nationality<span class="text-danger">*</span></label>
                                                            <select class="form-control" name="nationality_country_id" required>

                                                                @foreach($countries as $item)
                                                                <option value="{{$item->id}}" @php if ($item->id == $data->nationality_country_id) { echo "selected"; } @endphp>{{$item->name}}</option>
                                                                @endforeach

                                                            </select>
                                                        </div>
                                                    </div>



                                                    <div class="col-lg-12">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Phone Number<span class="text-danger">*</span></label>
                                                            <input type="text" id="instructor-name-input" name="phone_number" value="{{ $data->phone_number }}" class="form-control" placeholder="" required>
                                                        </div>
                                                    </div>



                                                    <div class="col-lg-12">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Email address<span class="text-danger">*</span></label>
                                                            <input type="text" id="instructor-name-input" name="email_address" value="{{ $data->email_address }}" class="form-control" placeholder="" required>
                                                        </div>
                                                    </div>

                                                 

                                                    <div class="col-lg-12">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Status<span class="text-danger">*</span></label>
                                                            <select class="form-control" name="status" required>
                                                                <option value="1" @php if ($data->status == 1) { echo "selected"; } @endphp>COMPELETE</option>
                                                                <option value="0" @php if ($data->status == 0) { echo "selected"; } @endphp>PENDING</option>
                                                            </select>
                                                        </div>
                                                    </div>

                                               
                                                  
                                                  
                                                </div><!--end row-->
                                            </div>
                                            <div class="modal-footer">
                                                <div class="hstack gap-2 justify-content-end">
                                                    <button type="button" class="btn btn-ghost-danger" data-bs-dismiss="modal"><i class="bi bi-x-lg align-baseline me-1"></i> Close</button>
                                                    <button type="submit" class="btn btn-primary" id="add-btn">Update</button>
                                                </div>
                                            </div>
                                        </form>
                          
                                </div>
                            </div>
                        </div><!--end col-->
                        <div class="col-lg-2"></div>
                    </div><!--end row-->


                </div>

            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->

    </div>



@stop