@extends('admin.layouts.app')

@section('head')
<title> Manage tour service | {{ config('app.name') }}  </title>
<meta name="csrf-token" content="{{csrf_token()}}">
@endsection

@section('content')

        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                <h4 class="mb-sm-0">tour service</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">tour service</a></li>
                                        <li class="breadcrumb-item active">List View</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div id="instructorList">

                      
    
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row align-items-center g-2">
                                            <div class="col-lg-3 me-auto">
                                                <h6 class="card-title mb-0">tour service List<span class="badge bg-primary ms-1 align-baseline"> {{ $datas->count() }} </span></h6>
                                            </div><!--end col-->
                                    
                                            <div class="col-sm-auto">
                                                <div class="hstack gap-2">
                                                

                                                    <a href="{{route('tour_service.create')}}" class="btn btn-secondary"><i class="bi bi-plus-circle align-baseline me-1"></i> Add tour service</a>
                                                </div>
                                            </div><!--end col-->
                                        </div>
                                    </div>
                                    <div class="card-body mt-3">
                                        <div class="table-responsive table-card">
                                            <table id="myTable" class="table table-centered align-middle table-custom-effect table-nowrap mb-0">
                                                <thead class="table-light">
                                                    <tr>
                                                       
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor_id">SL</th>
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor"> IMAGE</th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor"> TITLE</th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor"> PRICE</th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor"> CONTINENT</th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor"> COUNTRIES</th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor"> STATUS</th> 
                                                                                              
                                                        <th scope="col">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody class="list form-check-all">

                                                	@php $i = 1 @endphp
                                                	@foreach($datas as $item)

                                                    <?php
                                                        $tour_countries = App\Models\TourServiceCountry::where('tour_service_id', $item->id)->get();
                                                    ?>
                                                    <tr>
                                                      
                                                       
                                                        <td class="courses_total">{{ $i++ }}</td>

	                                                    <td class="courses_total"> 

	                                                    	<a href="{{ asset($item->meta_image) }}" target="_blank"><img src="{{ asset($item->meta_image) }}" alt="" style="width: 100px;"></a>

	                                                    </td>

                                                        <td class="courses_total">{{ $item->title }}</td>
                                                        <td class="courses_total">{{ $item->price_start_per_person ?? 0 }} /-</td>
                                                        <td class="courses_total">{{ $item->continent->name ?? '' }}</td>
                                                        <td class="courses_total">
                                                            @foreach($tour_countries as $tour_country)

                                                                <?php
                                                                    $colorCode = '#' . str_pad(dechex(random_int(0, 16777215)), 6, '0', STR_PAD_LEFT);
                                                                ?>

                                                                <span style="background: {{ $colorCode }};padding: 1px 5px;font-weight: bold;color: white;border-radius: 5px;">{{ $tour_country->country->name ?? '' }}</span>
                                                            @endforeach
                                                        </td>

                                                        <td class="courses_total">
                                                                
                                                            @if($item->status == 1)

                                                                <span class="badge bg-success">ACTIVE</span>

                                                            @else

                                                                <span class="badge bg-danger">INACTIVE</span>

                                                            @endif

                                                        </td>

                                                       
                                                       
                                                        <td>
                                                            <ul class="d-flex gap-2 list-unstyled mb-0">
                                                              
                                                                <li>
                                                                    <a href="{{URL::to('admin/tour_service/'.$item->id.'/edit')}}"  class="btn btn-subtle-secondary btn-icon btn-sm edit-item-btn"><i class="ph-pencil"></i></a>
                                                                </li>
                                                                <li>

											                        <form action="{{URL::to('admin/tour_service/'.$item->id)}}" method="post">

											                          @csrf

											                          @method('DELETE')

											                          <button  class="btn btn-subtle-danger btn-icon btn-sm remove-item-btn" type="submit">
											                          	<i class="ph-trash"></i>
											                          	</button>

											                        </form>

                                                                </li>
                                                            </ul>
                                                        </td>
                                                    </tr>
                                                    @endforeach

                                                </tbody><!-- end tbody -->
                                            </table><!-- end table -->
                                    
                                        </div>
                              
                                    </div>
                                </div>
                            </div><!--end col-->
                        </div><!--end row-->

                    </div>

                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

        </div>










@stop