@extends('admin.layouts.app')
@section('head')
<title>Create umrah service | {{ config('app.name') }}  </title>
<meta name="csrf-token" content="{{csrf_token()}}">
@endsection
@section('content')



    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                <!-- start page title -->
                <div class="row">
                    <div class="col-12">
                        <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                            <h4 class="mb-sm-0">umrah service</h4>

                            <div class="page-title-right">
                                <ol class="breadcrumb m-0">
                                    <li class="breadcrumb-item"><a href="javascript: void(0);">umrah service</a></li>
                                    <li class="breadcrumb-item active">Add umrah service</li>
                                </ol>
                            </div>

                        </div>
                    </div>
                </div>
                <!-- end page title -->

                <div id="instructorList">

                  

                    <div class="row">
           
                        <div class="col-lg-12">
                            <div class="card">
                                <div class="card-header">
                                    <div class="row align-items-center g-2">
                                        <div class="col-lg-3 me-auto">
                                            <h6 class="card-title mb-0">Add umrah service </h6>
                                        </div><!--end col-->
                             
                                        <div class="col-sm-auto">
                                            <div class="hstack gap-2">

                                                <a href="#" class="btn btn-secondary"><i class="bi bi-plus-circle align-baseline me-1"></i> Add umrah service</a>

                                            </div>
                                        </div><!--end col-->
                                    </div>
                                </div>
                                <div class="card-body mt-3">

							        @if ($errors->any())

							            <div class="alert alert-danger">

							                <ul>

							                    @foreach ($errors->all() as $error)

							                        <li>{{ $error }}</li>

							                    @endforeach

							                </ul>

							            </div>

							        @endif


                                    <form action="{{route('umrah_service.store')}}" method="post" enctype="multipart/form-data">
                      
                                        @csrf
                    


                                            <div class="modal-body">
                                                <div id="alert-error-msg" class="d-none alert alert-danger py-2"></div>
                                                <input type="hidden" id="id-field">
                                                <input type="hidden" id="rating-field">
                                              
                            
                                                <div class="row">
                                                    

                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Continent<span class="text-danger">*</span></label>
                                                            <select class="form-control continent_id select2" name="continent_id" onchange="getCountry(this.value)" required>
                                                                <option value="">Select</option>

                                                                @foreach($continents as $item)
                                                                <option value="{{$item->id}}">{{$item->name}}</option>
                                                                @endforeach

                                                            </select>
                                                        </div>
                                                    </div>


                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Country<span class="text-danger">*</span></label>
                                                            <select class="form-control country_id select2" name="country_id[]" multiple="" >
                                                                <option value="">Select</option>

                                                                

                                                            </select>
                                                        </div>
                                                    </div>


                                                    <div class="col-lg-4">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Expire Date<span class="text-danger">*</span></label>
                                                            <input type="date" id="instructor-name-input" name="expire_date" class="form-control" placeholder="Enter Title" >
                                                        </div>
                                                    </div>


                                                    <div class="col-lg-6">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Title<span class="text-danger">*</span></label>
                                                            <input type="text" id="instructor-name-input" name="title" class="form-control" placeholder="Enter Title" required>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-6">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Price Start ( Per Person )<span class="text-danger">*</span></label>
                                                            <input type="text" id="instructor-name-input" name="price_start_per_person" class="form-control" placeholder="Enter Price" required>
                                                        </div>
                                                    </div>


                                               

                                                    <div class="col-lg-6">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Details<span class="text-danger">*</span></label>
                                                            <textarea name="umrah_details" class="form-control" id="" cols="30" rows="10" required></textarea>

                                                            <script>
                                                                CKEDITOR.replace('umrah_details', {

                                                                    filebrowserUploadUrl: "{{route('ckeditor.upload', ['_token' => csrf_token() ])}}",

                                                                    filebrowserUploadMethod: 'form'

                                                                });

                                                                CKEDITOR.instances['umrah_details'].setData({!! json_encode($data->umrah_details ?? '') !!})
                                                             </script>

                                                        </div>
                                                    </div>


                                                    <div class="col-lg-6">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Other Information</label>
                                                            <textarea name="umrah_other_information" class="form-control" id="" cols="30" rows="10" required></textarea>

                                                            <script>
                                                                CKEDITOR.replace('umrah_other_information', {

                                                                    filebrowserUploadUrl: "{{route('ckeditor.upload', ['_token' => csrf_token() ])}}",

                                                                    filebrowserUploadMethod: 'form'

                                                                });

                                                                CKEDITOR.instances['umrah_other_information'].setData({!! json_encode($data->umrah_other_information ?? '') !!})
                                                             </script>

                                                        </div>
                                                    </div>



                                                    <div class="col-lg-6">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Remark</label>
                                                            <textarea name="umrah_remark" class="form-control" id="" cols="30" rows="10" ></textarea>

                                                            <script>
                                                                CKEDITOR.replace('umrah_remark', {

                                                                    filebrowserUploadUrl: "{{route('ckeditor.upload', ['_token' => csrf_token() ])}}",

                                                                    filebrowserUploadMethod: 'form'

                                                                });

                                                                CKEDITOR.instances['umrah_remark'].setData({!! json_encode($data->umrah_faq ?? '') !!})
                                                             </script>

                                                        </div>
                                                    </div>


                                                    <div class="col-lg-6">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Itinerary</label>
                                                            <textarea name="umrah_itinerary" class="form-control" id="" cols="30" rows="10" ></textarea>

                                                            <script>
                                                                CKEDITOR.replace('umrah_itinerary', {

                                                                    filebrowserUploadUrl: "{{route('ckeditor.upload', ['_token' => csrf_token() ])}}",

                                                                    filebrowserUploadMethod: 'form'

                                                                });

                                                                CKEDITOR.instances['umrah_itinerary'].setData({!! json_encode($data->umrah_faq ?? '') !!})
                                                             </script>

                                                        </div>
                                                    </div>


                                                    <div class="col-lg-6">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Other FAQ</label>
                                                            <textarea name="umrah_faq" class="form-control" id="" cols="30" rows="10" required></textarea>

                                                            <script>
                                                                CKEDITOR.replace('umrah_faq', {

                                                                    filebrowserUploadUrl: "{{route('ckeditor.upload', ['_token' => csrf_token() ])}}",

                                                                    filebrowserUploadMethod: 'form'

                                                                });

                                                                CKEDITOR.instances['umrah_faq'].setData({!! json_encode($data->umrah_faq ?? '') !!})
                                                             </script>

                                                        </div>
                                                    </div>



                                                    <div class="col-lg-6">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Best umrah Service For</label>
                                                            <textarea name="best_umrah_service_for" class="form-control" id="" cols="30" rows="10" required></textarea>

                                                            <script>
                                                                CKEDITOR.replace('best_umrah_service_for', {

                                                                    filebrowserUploadUrl: "{{route('ckeditor.upload', ['_token' => csrf_token() ])}}",

                                                                    filebrowserUploadMethod: 'form'

                                                                });

                                                                CKEDITOR.instances['best_umrah_service_for'].setData({!! json_encode($data->best_umrah_service_for ?? '') !!})
                                                             </script>

                                                        </div>
                                                    </div>


                                                    <div class="col-lg-12">
                                                    	
	                                                    <br>
	                                                    <br>
	                                                    <h6 class="card-title mb-0" style="color: red;"> SEO Settings</h6>
	                                                    <br>


                                                    </div>

                                                    <div class="col-lg-6">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Meta Title</label>
                                                            <input type="text" id="instructor-name-input" name="meta_title" class="form-control" placeholder="Enter Meta Title" >
                                                        </div>
                                                    </div>


                                                    <div class="col-lg-6">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Meta Description</label>
                                                            <input type="text" id="instructor-name-input" name="meta_description" class="form-control" placeholder="Enter Meta Description" >
                                                        </div>
                                                    </div>


                                                    <div class="col-lg-6">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Meta Keywords</label>
                                                            <input type="text" id="instructor-name-input" name="meta_keywords" class="form-control" placeholder="Enter Meta Keywords" >
                                                        </div>
                                                    </div>


                                                    <div class="col-lg-6">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Meta Image</label>
                                                            <input type="file" id="instructor-name-input" name="meta_image" class="form-control" required>
                                                        </div>
                                                    </div>

                                                 

                                                    <div class="col-lg-6">
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Status<span class="text-danger">*</span></label>
                                                            <select class="form-control" name="status" required>
                                                                <option value="1">Active</option>
                                                                <option value="0">Inactive</option>
                                                            </select>
                                                        </div>
                                                    </div>

                                                    <div class="col-lg-12">
                                                    	<br>
                                                    	<br>
                                                    	<br>
                                                        <div class="mb-3">
                                                            <label for="instructor-name-input" class="form-label">Images<span class="text-danger">*</span></label>
			                                                <table class="table" id="umrah_image_row_table">
			                                                    <thead>
			                                                        <tr>
			                                                            <th>Image</th>
			                                                        </tr>
			                                                    </thead>
			                                                    <tbody>
			                                                        <tr class="umrah_image_row">

			                                                            <td>
			                                                                <input type="file" name="image[]" class="form-control">
			                                                            </td>

			                                                        </tr>
			                                                        <tr></tr>
			                                                    </tbody>
			                                                </table>
                                                        </div>
                                                    </div>


                                                    <div class="col-lg-12">
														<label style="font-size: 12px; cursor: pointer;" class="add_umrah_image_row"><i class="bi bi-plus-circle align-baseline me-1"></i> Add another image </label>
                                                    </div>

                                                 
                                                  
                                                </div><!--end row-->
                                            </div>
                                            <div class="modal-footer">
                                                <div class="hstack gap-2 justify-content-end">
                                                    <button type="button" class="btn btn-ghost-danger" data-bs-dismiss="modal"><i class="bi bi-x-lg align-baseline me-1"></i> Close</button>
                                                    <button type="submit" class="btn btn-primary" id="add-btn">Save</button>
                                                </div>
                                            </div>
                                        </form>
                          
                                </div>
                            </div>
                        </div><!--end col-->
   
                    </div><!--end row-->

                </div>

            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->

    </div>


@endsection