@extends('frontend.layouts.app')
@section('head')

<?php
    $host = url()->full();
?>


<title> Contact us | {{ $site_info->name ?? '' }}</title>
<meta name="csrf-token" content="{{csrf_token()}}">
  <meta name="description" content="{{ $blog->meta_description ?? '' }}" />

  <meta property="type" content="Website" />

  <link rel="canonical" href="{{ $host }}" />

  <meta name="robots" content="index,allow" />

  <meta name="author" content="{{ $site_info->name ?? '' }}" />

  <meta name="publisher" content="{{ $site_info->name ?? '' }}" />

  <meta property="site_name" content=" Contact us | {{ $site_info->name ?? '' }}" />

  <meta property="og:url" content="{{ $host }}/" />

  <meta property="og:type" content="website" />

  <meta property="og:title" content=" Contact us| {{ $site_info->name ?? '' }}" />

  <meta property="og:description" content="{{ $site_info->meta_description ?? '' }}" />

  <meta property="og:keywords" content="{{ $site_info->meta_keywords ?? '' }}" />

  <meta property="og:image" content="{{ asset($site_info->meta_image ?? '') }}" />

  <meta name="twitter:card" content="summary" />
  
  <meta name="twitter:site" content="@ {{ $site_info->name ?? '' }}" />

  <meta name="twitter:creator" content="@ {{ $site_info->name ?? '' }}" />

  <meta property="twitter:url" content="{{ $host }}/" />

  <meta property="twitter:title" content=" Contact us | {{ $site_info->name ?? '' }}" />

  <meta property="twitter:description" content="{{ $site_info->meta_description ?? '' }}" />

  <meta property="twitter:keywords" content="{{ $site_info->meta_keywords ?? '' }}" />

  <meta property="twitter:image" content="{{ asset($site_info->meta_image ?? '') }}" />


@endsection
@section('content')

 <section class="about-page-banner-section" style="background-image: url({{asset('public/frontend/')}}/images/tour-package.jpg);">
    <div class="container">
        <div class="about-slug text-center">
            <h2 class="">Contact Us</h2>
        </div>
    </div>
    <div class="about-page-banner-overlay">

    </div>
 </section>

 <section class="company-overview-container-section">
    <div class="container">
        <iframe src="{{$site_info->google_map_embed}}" width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
    </div>
 </section>

 <div class="contact-info-section">
    <div class="container">
        <div class="row g-4">
            <div class="col-md-4">
                <div class="contact-info-cart text-center">
                   <div class="text-center">
                    <img src="../images/location.png" alt="">
                   </div>
                   <h4>Find Us at</h4>
                   <p>{{$site_info->address}}</p>
                </div>
            </div>
            <div class="col-md-4">
                <div class="contact-info-cart text-center">
                   <div class="text-center">
                    <img src="../images/gmail.png" alt="">
                   </div>
                   <h4>Email Us at</h4>

                    <?php
                        $emails = explode(", ", $site_info->email);
                        $totalEmails = count($emails);
                        $i = 1;
                        $icon = '<i class="fa-solid fa-envelope"></i>';
                    ?>
                    @foreach($emails as $item)

                        <p class="mb-0 text-center"><a href="mailto:{{ $item }}">{{ $item }}</a></p>

                      @php $i++; @endphp
                    @endforeach


                </div>
            </div>
            <div class="col-md-4">
                <div class="contact-info-cart text-center">
                   <div class="text-center">
                    <img src="../images/phone-call.png" alt="">
                   </div>
                   <h4>Call Us at</h4>

                      <?php
                          $phones = explode(", ", $site_info->phone_number);
                          $totalPhones = count($phones);
                          $i = 1;
                          $icon = '<i class="fa-solid fa-phone"></i>';
                      ?>

                      @foreach($phones as $item)


                        <p class="mb-0 text-center"><a href="tel:{{ $item }} ">{{ $item }} </a></p>


                        @php $i++; @endphp
                      @endforeach

                </div>
            </div>
        </div>
    </div>
 </div>

 <section class="get-in-touch-section">
    <div class="container">
        <div class="get-in-touch-title text-center">
            <h2>Get In Touch</h2>
        </div>
        <div class="row g-4">
            <div class="col-md-6">
                <div class="get-in-touch-info">
                    
                    {!! $page_des->contact_page_description !!}

                </div>
            </div>
            <div class="col-md-6">
                <div class="get-in-touch-form">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif
                    
                    <form action="{{ route('submit_message') }}" method="post">
                        @csrf
                        <div class="single-input mb-3">
                            <input type="text" name="full_name" class="form-control shadow-none" placeholder="Enter Your Name">
                        </div>
                        <div class="single-input mb-3">
                            <input type="text" name="phone_number"  class="form-control shadow-none" placeholder="Entry Your Contact Number">
                        </div>
                     
                        <div class="single-input mb-3">
                            <textarea  name="message" id="" cols="10" rows="4" class="form-control shadow-none" placeholder="Your Massage"></textarea>
                        </div>
                        <div class="single-input mb-3">
                          <button  type="submit" class="btn w-100">SEND MESSAGE <i class="fa-solid fa-paper-plane"></i></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
 </section>
  

@endsection
