<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <?php
        $site_info = App\Models\WebsiteInformation::first();
    ?>

    <?php echo $__env->yieldContent('head'); ?>
    

    <link rel="shortcut icon" href="<?php echo e(asset($site_info->fav_icon ?? '')); ?>" type="image/x-icon" />

    <link rel="stylesheet" href="<?php echo e(asset('public/frontend/')); ?>/css/all.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('public/frontend/')); ?>/css/bootstrap.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('public/frontend/')); ?>/css/slick.css">
    <link rel="stylesheet" href="<?php echo e(asset('public/frontend/')); ?>/css/style.css">
    <link rel="stylesheet" href="<?php echo e(asset('public/frontend/')); ?>/css/responsive.css">
    <link rel="stylesheet" href="<?php echo e(asset('public/frontend/')); ?>//css/mdb.min.css">

    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

    
  </head>

  <body >


    <?php echo $__env->make('sweetalert::alert', ['cdn' => "https://cdn.jsdelivr.net/npm/sweetalert2@9"], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <?php echo $__env->make('frontend.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldContent('content'); ?>

    <?php echo $__env->make('frontend.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    
    <script src="<?php echo e(asset('public/frontend/')); ?>/js/jquery-3.7.0.min.js"></script>
    <script src="<?php echo e(asset('public/frontend/')); ?>/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo e(asset('public/frontend/')); ?>/js/slick.min.js"></script>
    <script src="<?php echo e(asset('public/frontend/')); ?>/js/script.js"></script>

    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>


    <script type="text/javascript" src="https://platform-api.sharethis.com/js/sharethis.js#property=64b39a9bd23b930012608faa&product=sticky-share-buttons&source=platform" async="async"></script>  <!-- branexit621@gmail.com & Branexit@621-->



    

    <div id="fb-root"></div>
    <script>(function(d, s, id) {
    var js, fjs = d.getElementsByTagName(s)[0];
    if (d.getElementById(id)) return;
    js = d.createElement(s); js.id = id;
    js.src = "https://connect.facebook.net/en_US/sdk.js#xfbml=1&version=v3.0";
    fjs.parentNode.insertBefore(js, fjs);
    }(document, 'script', 'facebook-jssdk'));</script>




    <?php echo $__env->make('frontend.layouts.js_script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<!--     <script>
        function disableRightClick(event) {
            event.preventDefault();
        }
        document.addEventListener('contextmenu', disableRightClick);
    </script>


    <script>
        // Disable Ctrl+U
        document.addEventListener('keydown', function(event) {
            if (event.ctrlKey && event.key === 'u') {
                event.preventDefault();
            }
        });
    </script> -->

</body>
</html>



<?php /**PATH D:\xampp\htdocs\office\obokash_tour\resources\views/frontend/layouts/app.blade.php ENDPATH**/ ?>