

<?php $__env->startSection('title'); ?>
<title> Manage Confirmed order | <?php echo e(config('app.name')); ?>  </title>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                <h4 class="mb-sm-0">Confirmed order</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Confirmed order</a></li>
                                        <li class="breadcrumb-item active">List View</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div id="instructorList">

                      
    
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row align-items-center g-2">
                                            <div class="col-lg-3 me-auto">
                                                <h6 class="card-title mb-0">Confirmed Order List <span class="badge bg-primary ms-1 align-baseline"> <?php echo e($datas->count()); ?> </span></h6>
                                            </div><!--end col-->
                                            <div class="col-xl-2 col-lg-3 col-sm-5">
                                                <div class="search-box">
                                                    <input type="text" class="form-control search" placeholder="Search for instructors, email, contact number or something...">
                                                    <i class="ri-search-line search-icon"></i>
                                                </div>
                                            </div><!--end col-->
                                            <div class="col-sm-auto">
                                                <div class="hstack gap-2">
                                                    <button class="btn btn-subtle-danger d-none" id="remove-actions" ><i class="ri-delete-bin-2-line"></i></button>

                                                </div>
                                            </div><!--end col-->
                                        </div>
                                    </div>
                                    <div class="card-body mt-3">
                                        <div class="table-responsive table-card">
                                            <table class="table table-centered align-middle table-custom-effect table-nowrap mb-0">
                                                <thead class="table-light">
                                                    <tr>
                                                       
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor_id">SL</th>
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor_id">DATE</th>
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor_id">Order Code</th>
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor">CUSTOMAR NAME</th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor">CUSTOMAR PHONE</th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor">CUSTOMAR AREA</th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor">PRODUCT NAME </th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor">PRICE </th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor">PAYMENT STATUS </th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor">STATUS </th> 		
                                                                                              
                                                        <th scope="col">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody class="list form-check-all">

                                                	<?php $i = 1 ?>
                                                	<?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                      
                                                       
                                                        <td class="courses_total"><?php echo e($i++); ?></td>
                                                        <td class="courses_total">
                                                                

                                                            <?php echo e(Carbon\Carbon::parse($item->created_at)->format('d M Y')); ?>


                                                        </td>
                                                        <td class="courses_total"><?php echo e($item->invoice_id); ?></td>
                                                        <td class="courses_total"><?php echo e($item->name); ?></td>
                                                        <td class="courses_total"><?php echo e($item->phone_number); ?></td>
                                                        <td class="courses_total"><?php echo e($item->district); ?></td>

														<td class="products">
                                                            <div class="d-flex align-items-center">
                                                                <div class="avatar-xs bg-light rounded p-1 me-2">
                                                                    <img src="<?php echo e(asset($item->product->image ?? '')); ?>" alt="" class="img-fluid d-block">
                                                                </div>
                                                                <div>
                                                                    <h6 class="mb-0"><a href="#" class="text-reset products"><?php echo e($item->product->name ?? ''); ?></a></h6>
                                                                </div>
                                                            </div>
                                                        </td>

                                                        <td class="courses_total"><?php echo e($item->total); ?></td>

                                                        <td>

                                                        	<?php if($item->payment_status == 0): ?>

                                                        		<span class="badge bg-danger">UNPAID</span>

                                                        	<?php else: ?>
                                                        		<span class="badge bg-success">PAID</span>

                                                        	<?php endif; ?>


                                                        </td>


                                                        <td>

                                                        	<?php if($item->status == 0): ?>

                                                        		<span class="badge bg-warning">PENDING</span>

                                                        	<?php endif; ?>

                                                        	<?php if($item->status == 1): ?>

                                                        		<span class="badge bg-success">CONFIRMED</span>

                                                        	<?php endif; ?>

                                                        	<?php if($item->status == 2): ?>

                                                        		<span class="badge bg-danger">REJECTED</span>

                                                        	<?php endif; ?>

                                                        	<?php if($item->status == 3): ?>

                                                        		<span class="badge bg-info">PROCESSING</span>

                                                        	<?php endif; ?>

                                                        	<?php if($item->status == 4): ?>

                                                        		<span class="badge bg-info">In Transit Products</span>

                                                        	<?php endif; ?>

                                                        	<?php if($item->status == 5): ?>

                                                        		<span class="badge bg-info">Delivered Products</span>

                                                        	<?php endif; ?>

                                                        	<?php if($item->status == 6): ?>

                                                        		<span class="badge bg-danger">Cancelled Products</span>

                                                        	<?php endif; ?>


                                                        </td>
                                                       
                                                       
                                                        <td>
                                                            <ul class="d-flex gap-2 list-unstyled mb-0">
                                                              

                                                                <li>
                                                                    <a href="#editOrder" data-bs-toggle="modal" class="btn btn-subtle-secondary btn-icon btn-sm edit-item-btn" onclick="editOrderModal(<?php echo e($item->id); ?>)"><i class="ph-pencil"></i></a>
                                                                </li>


                                                                <li>

	 																<li>
	                                                                    <a href="#deleteRecordModal" data-bs-toggle="modal" class="btn btn-subtle-danger btn-icon btn-sm remove-item-btn" onclick="deleteModal(<?php echo e($item->id); ?>)"><i class="ph-trash"></i></a>
	                                                                </li>


                                                                </li>
                                                            </ul>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </tbody><!-- end tbody -->
                                            </table><!-- end table -->
                                    
                                        </div>
                              
                                    </div>
                                </div>
                            </div><!--end col-->
                        </div><!--end row-->

                    </div>

                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

        </div>



    <div class="modal fade" id="editOrder" tabindex="-1" aria-labelledby="editOrderModalLabel" aria-hidden="true">
        <div class="modal-dialog editOrderModal">

        </div>
    </div><!--end modal-->


    <!-- deleteRecordModal -->
    <div id="deleteRecordModal" class="modal fade zoomIn" tabindex="-1" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered deleteModel">

        </div><!-- /.modal-dialog -->
    </div><!-- /deleteRecordModal -->


<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\asifur_vai\shopix\resources\views/admin/order/confirmed_order.blade.php ENDPATH**/ ?>