
<?php $__env->startSection('head'); ?>

	<title><?php echo e($course->name); ?> | <?php echo e($site_info->name ?? ''); ?></title>
	<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

  <meta name="description" content="<?php echo e($course->name); ?>" />

  <meta property="type" content="course" />

  <link rel="canonical" href="http://localhost/office/gravity_new/" />

  <meta name="robots" content="index,allow" />

  <meta name="author" content="<?php echo e($site_info->name ?? ''); ?>" />

  <meta name="publisher" content="BranexIT" />

  <meta property="site_name" content="<?php echo e($site_info->name); ?>" />

  <meta property="og:url" content="<?php echo e(route('course-details', ['slug' => $course->slug, 'id' => $course->id])); ?>" />

  <meta property="og:type" content="website" />

  <meta property="og:title" content="<?php echo e($course->name); ?>" />

  <meta property="og:description" content="<?php echo e($course->name); ?>" />

  <meta property="og:keywords" content="<?php echo e($course->name); ?>" />

  <meta property="og:image" content="<?php echo e(asset($course->image ?? '')); ?>" />

  <meta name="twitter:card" content="summary" /><meta name="twitter:site" content="{{ $course->name ?? '' }}" />

  <meta name="twitter:creator" content="{{ $site_info->name ?? '' }}" />

  <meta property="twitter:url" content="<?php echo e(route('course-details', ['slug' => $course->slug, 'id' => $course->id])); ?>" />

  <meta property="twitter:title" content="<?php echo e($course->name); ?>" />

  <meta property="twitter:description" content="<?php echo e($course->name); ?>" />

  <meta property="twitter:keywords" content="<?php echo e($course->name); ?>" />

  <meta property="twitter:image" content="<?php echo e(asset($course->image ?? '')); ?>" />


<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


    <section class="course-details-section">
        <div class="container">
            <div class="row g-4">
                <div class="col-md-6">
                    <div class="course-summery">
                        <h2> <?php echo e($course->name); ?> </h2>
                        <ul class="p-0">


                        	<?php if($course->feature_one): ?>
                            <li> <span><i class="fa-solid fa-circle"></i></span> <?php echo e($course->feature_one); ?> </li>
                            <?php endif; ?>

                        	<?php if($course->feature_two): ?>
                            <li> <span><i class="fa-solid fa-circle"></i></span> <?php echo e($course->feature_two); ?> </li>
                            <?php endif; ?>

                        	<?php if($course->feature_three): ?>
                            <li> <span><i class="fa-solid fa-circle"></i></span> <?php echo e($course->feature_three); ?> </li>
                            <?php endif; ?>

                        	<?php if($course->feature_four): ?>
                            <li> <span><i class="fa-solid fa-circle"></i></span> <?php echo e($course->feature_four); ?> </li>
                            <?php endif; ?>

                        	<?php if($course->feature_five): ?>
                            <li> <span><i class="fa-solid fa-circle"></i></span> <?php echo e($course->feature_five); ?> </li>
                            <?php endif; ?>

                        	<?php if($course->feature_six): ?>
                            <li> <span><i class="fa-solid fa-circle"></i></span> <?php echo e($course->feature_six); ?> </li>
                            <?php endif; ?>

                        	<?php if($course->feature_seven): ?>
                            <li> <span><i class="fa-solid fa-circle"></i></span> <?php echo e($course->feature_seven); ?> </li>
                            <?php endif; ?>

                        	<?php if($course->feature_eight): ?>
                            <li> <span><i class="fa-solid fa-circle"></i></span> <?php echo e($course->feature_eight); ?> </li>
                            <?php endif; ?>

                        	<?php if($course->feature_nine): ?>
                            <li> <span><i class="fa-solid fa-circle"></i></span> <?php echo e($course->feature_nine); ?> </li>
                            <?php endif; ?>

                        	<?php if($course->feature_ten): ?>
                            <li> <span><i class="fa-solid fa-circle"></i></span> <?php echo e($course->feature_ten); ?> </li>
                            <?php endif; ?>




                   
                        </ul>

                        <div class="d-flex jonoprio-course-enroll">

                            <?php if($course->routine): ?>
                            <a href="<?php echo e(asset($course->routine)); ?>" target="_blank">রুটিন ডাউনলোড করুন</a>
                            <?php endif; ?>
                            
                            <a href="<?php echo e(route('pay-now', $course->id)); ?>">কোর্স কিনুন</a>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="course-overview-video">

                    	<?php if($course->video_link): ?>
                        	<iframe width="560" height="315" src="https://www.youtube.com/embed/<?php echo e($course->video_link); ?>" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" allowfullscreen></iframe>
                        <?php else: ?>

                        	<img src="<?php echo e(asset($course->image)); ?>" alt="<?php echo e($course->name); ?>">

                        <?php endif; ?>

                    </div>
                </div>
            </div>
        </div>
    </section>


    <section class="course-details-info-section">
        <div class="container">
            <div class="course-details-info-container">
                <div class="course-overview-title">
                    <h2>কোর্স বিস্তারিত </h2>
                </div>

                <?php echo $course->description ?? ''; ?>

            
            <div class="d-flex jonoprio-course-enroll">

            	<?php if($course->routine): ?>
                <a href="<?php echo e(asset($course->routine)); ?>" target="_blank">রুটিন ডাউনলোড করুন</a>
                <?php endif; ?>


                <a href="<?php echo e(route('pay-now', $course->id)); ?>">কোর্স কিনুন</a>
            </div>
              
            </div>
        </div>
    </section>








<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\office\gravity_new\resources\views/frontend/pages/course_details.blade.php ENDPATH**/ ?>