
<?php $__env->startSection('head'); ?>
<title> Manage Guest Request | <?php echo e(config('app.name')); ?> </title>
<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>


        <div class="main-content">

            <div class="page-content">
                <div class="container-fluid">

                    <!-- start page title -->
                    <div class="row">
                        <div class="col-12">
                            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                                <h4 class="mb-sm-0">Guest Request</h4>

                                <div class="page-title-right">
                                    <ol class="breadcrumb m-0">
                                        <li class="breadcrumb-item"><a href="javascript: void(0);">Guest Request</a></li>
                                        <li class="breadcrumb-item active">List View</li>
                                    </ol>
                                </div>

                            </div>
                        </div>
                    </div>
                    <!-- end page title -->

                    <div id="instructorList">

                      
    
                        <div class="row">
                            <div class="col-lg-12">
                                <div class="card">
                                    <div class="card-header">
                                        <div class="row align-items-center g-2">
                                            <div class="col-lg-3 me-auto">
                                                <h6 class="card-title mb-0">Guest Request List<span class="badge bg-primary ms-1 align-baseline"> <?php echo e($datas->count()); ?> </span></h6>
                                            </div><!--end col-->
                                            <div class="col-xl-2 col-lg-3 col-sm-5">
                                                <div class="search-box">
                                                    <input type="text" class="form-control search" placeholder="Search for instructors, email, contact number or something...">
                                                    <i class="ri-search-line search-icon"></i>
                                                </div>
                                            </div><!--end col-->
                                            <div class="col-sm-auto">
                                                <div class="hstack gap-2">

                                                    <button class="btn btn-subtle-danger d-none" id="remove-actions" ><i class="ri-delete-bin-2-line"></i></button>

                                                </div>
                                            </div><!--end col-->
                                        </div>
                                    </div>
                                    <div class="card-body mt-3">
                                        <div class="table-responsive table-card">
                                            <table class="table table-centered align-middle table-custom-effect table-nowrap mb-0">
                                                <thead class="table-light">
                                                    <tr>
                                                       
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor_id">SL</th>
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor">TYPE</th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor">WANT TO GO</th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor">NATIONALITY</th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor">PHONE NUMBER</th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor"> EMAIL</th> 
                                                        <th scope="col" class="sort cursor-pointer" data-sort="instructor"> STATUS</th> 
                                                                                              
                                                        <th scope="col">ACTION</th>
                                                    </tr>
                                                </thead>
                                                <tbody class="list form-check-all">

                                                    <?php $i = 1 ?>
                                                    <?php $__currentLoopData = $datas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                      
                                                       
                                                        <td class="courses_total"><?php echo e($i++); ?></td>
                                                        <td class="courses_total"><?php echo e($item->type); ?></td>
                                                        <td class="courses_total"><?php echo e($item->want_to_go_country->name ?? ''); ?></td>
                                                        <td class="courses_total"><?php echo e($item->nationality_country->name ?? ''); ?></td>
                                                        <td class="courses_total"><?php echo e($item->phone_number); ?></td>
                                                        <td class="courses_total"><?php echo e($item->email_address); ?></td>
                                                       
                                                        <td class="courses_total">
                                                                
                                                            <?php if($item->status == 1): ?>

                                                                <span class="badge bg-success">COMPLETE</span>

                                                            <?php else: ?>

                                                                <span class="badge bg-danger">PENDING</span>

                                                            <?php endif; ?>

                                                        </td>
                                                       

                                                        <td>
                                                            <ul class="d-flex gap-2 list-unstyled mb-0">
                                                              
                                                                <li>
                                                                    <a href="<?php echo e(URL::to('admin/guest_request/'.$item->id.'/edit')); ?>"  class="btn btn-subtle-secondary btn-icon btn-sm edit-item-btn"><i class="ph-pencil"></i></a>
                                                                </li>
                                                                <li>

                                                                    <form action="<?php echo e(URL::to('admin/guest_request/'.$item->id)); ?>" method="post">

                                                                      <?php echo csrf_field(); ?>

                                                                      <?php echo method_field('DELETE'); ?>

                                                                      <button  class="btn btn-subtle-danger btn-icon btn-sm remove-item-btn" type="submit">
                                                                        <i class="ph-trash"></i>
                                                                        </button>

                                                                    </form>

                                                                </li>
                                                            </ul>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                </tbody><!-- end tbody -->
                                            </table><!-- end table -->
                                    
                                        </div>
                              
                                    </div>
                                </div>
                            </div><!--end col-->
                        </div><!--end row-->

                    </div>

                </div>
                <!-- container-fluid -->
            </div>
            <!-- End Page-content -->

        </div>



<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\office\obokash_tour\resources\views/admin/quest_request/index.blade.php ENDPATH**/ ?>