<!doctype html>
<html lang="en" data-layout="vertical" data-sidebar="dark" data-sidebar-size="lg" data-preloader="disable" data-theme="default" data-topbar="light" data-bs-theme="light">




<head>

    <meta charset="utf-8">
    <title>Dashboard | Shopix - Admin & Dashboard </title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Minimal Admin & Dashboard Template" name="description">
    <meta content="Themesbrand" name="author">



    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">




    <!-- App favicon -->
    <link rel="shortcut icon" href="<?php echo e(asset('public/backend')); ?>/assets/images/favicon.ico">

    <!-- Fonts css load -->
    <link rel="preconnect" href="https://fonts.googleapis.com/">
    <link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin>
    <link id="fontsLink" href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700&amp;display=swap" rel="stylesheet">

    <!-- jsvectormap css -->
    <link href="<?php echo e(asset('public/backend')); ?>/assets/libs/jsvectormap/css/jsvectormap.min.css" rel="stylesheet" type="text/css">

    <!-- Layout config Js -->
    <script src="<?php echo e(asset('public/backend')); ?>/assets/js/layout.js"></script>
    <!-- Bootstrap Css -->
    <link href="<?php echo e(asset('public/backend')); ?>/assets/css/bootstrap.min.css" rel="stylesheet" type="text/css">
    <!-- Icons Css -->
    <link href="<?php echo e(asset('public/backend')); ?>/assets/css/icons.min.css" rel="stylesheet" type="text/css">
    <!-- App Css-->
    <link href="<?php echo e(asset('public/backend')); ?>/assets/css/app.min.css" rel="stylesheet" type="text/css">
    <!-- custom Css-->
    <link href="<?php echo e(asset('public/backend')); ?>/assets/css/custom.min.css" rel="stylesheet" type="text/css">


    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.css" rel="stylesheet">





</head>

<body>


        <div id="layout-wrapper">



            <?php echo $__env->make('sweetalert::alert', ['cdn' => "https://cdn.jsdelivr.net/npm/sweetalert2@9"], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


            <?php echo $__env->make('admin.layouts.sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


            <?php echo $__env->make('admin.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


            <?php echo $__env->yieldContent('content'); ?>


            <?php echo $__env->make('admin.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


              
        </div>


        <script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>



        <!-- JAVASCRIPT -->
        <script src="<?php echo e(asset('public/backend')); ?>/assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>
        <script src="<?php echo e(asset('public/backend')); ?>/assets/libs/simplebar/simplebar.min.js"></script>
        <script src="<?php echo e(asset('public/backend')); ?>/assets/js/plugins.js"></script>
        
        <!-- apexcharts -->
        <script src="<?php echo e(asset('public/backend')); ?>/assets/libs/apexcharts/apexcharts.min.js"></script>
     <!--dashboard learning init js-->
        <script src="<?php echo e(asset('public/backend')); ?>/assets/js/pages/dashboard-learning.init.js"></script>
        <!-- Echarts -->
        <script src="<?php echo e(asset('public/backend')); ?>/assets/libs/echarts/echarts.min.js"></script>

        <!-- Vector map-->
        <script src="<?php echo e(asset('public/backend')); ?>/assets/libs/jsvectormap/js/jsvectormap.min.js"></script>
        <script src="<?php echo e(asset('public/backend')); ?>/assets/libs/jsvectormap/maps/world-merc.js"></script>

        <script src="<?php echo e(asset('public/backend')); ?>/assets/libs/list.js/list.min.js"></script>
        
        

        <!-- dashboard-analytics init js -->
        <script src="<?php echo e(asset('public/backend')); ?>/assets/js/pages/dashboard-analytics.init.js"></script>

        <!-- App js -->
        <script src="<?php echo e(asset('public/backend')); ?>/assets/js/app.js"></script>


        <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote.min.js"></script>



        <script>
           

            $( document ).ready(function() {
                $.ajaxSetup({
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    }
                });
            });


            $(document).on('click', '.add_image_row', function() {
                var html = '';
                html += '<tr class="image_row">' +

                    '<td><input type="file" name="image[]" class="form-control"></td>' +
                   
                    '<td><button type="button" name="remove" class="btn btn-danger btn-lg remove"><span class="bi bi-x-lg mt-2 mb-2"></span></button></td></tr>';
                $('#image_row_table').append(html);
            });

            $(document).on('click', '.remove', function() {
                $(this).closest('tr').remove();
            });



            $(document).ready(function() {
              $('.summernote').summernote();
            });




            function editOrderModal(val){


                var token =  $("input[name=_token]").val();
                var datastr = "order_id=" + val  + "&token="+token;

                $.ajax({
                  type: "post",
                  url: "<?php echo route('admin.edit_order_model');?>",
                  data:datastr,
                  cache:false,
                  beforeSend: function() {
                      // setting a timeout
                  },
                  success:function (data) {            
                    $('.editOrderModal').html(data);

                  },
                  error: function (jqXHR, status, err) {
                    alert(status);
                    console.log(err);
                  },
                  complete: function () {
                    // alert("Complete");
                  }
                });
              }



            function deleteModal(val){


                var token =  $("input[name=_token]").val();
                var datastr = "order_id=" + val  + "&token="+token;

                $.ajax({
                  type: "post",
                  url: "<?php echo route('admin.delete_model');?>",
                  data:datastr,
                  cache:false,
                  beforeSend: function() {
                      // setting a timeout
                  },
                  success:function (data) {            
                    $('.deleteModel').html(data);

                  },
                  error: function (jqXHR, status, err) {
                    alert(status);
                    console.log(err);
                  },
                  complete: function () {
                    // alert("Complete");
                  }
                });
              }




            function stockHistory(val){


                var token =  $("input[name=_token]").val();
                var datastr = "product_id=" + val  + "&token="+token;

                $.ajax({
                  type: "post",
                  url: "<?php echo route('admin.stock_history');?>",
                  data:datastr,
                  cache:false,
                  beforeSend: function() {
                      // setting a timeout
                  },
                  success:function (data) {            
                    $('.stockHistoryModal').html(data);

                  },
                  error: function (jqXHR, status, err) {
                    alert(status);
                    console.log(err);
                  },
                  complete: function () {
                    // alert("Complete");
                  }
                });
              }




        </script>   


</body>


</html><?php /**PATH D:\xampp\htdocs\asifur_vai\shopix\resources\views/admin/layouts/app.blade.php ENDPATH**/ ?>