<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <?php
        $site_info = App\Models\WebsiteInformation::first();
    ?>

    <?php echo $__env->yieldContent('head'); ?>
    

    <link rel="shortcut icon" href="<?php echo e(asset($site_info->fav_icon ?? '')); ?>" type="image/x-icon" />
     <!-- font awesome -->
     <link rel="stylesheet" href="<?php echo e(asset('public/frontend/')); ?>/css/all.min.css">
     <!-- slick -->
     <link rel="stylesheet" href="<?php echo e(asset('public/frontend/')); ?>/css/slick.css">
     <!-- bootstrap -->
     <link rel="stylesheet" href="<?php echo e(asset('public/frontend/')); ?>/webfonts/bangla-fonts.css">
     <link rel="stylesheet" href="<?php echo e(asset('public/frontend/')); ?>/css/bootstrap.min.css">
     <link rel="stylesheet" href="<?php echo e(asset('public/frontend/')); ?>/css/style.css">
     <link rel="stylesheet" href="<?php echo e(asset('public/frontend/')); ?>/css/responsive.css">

    
  </head>

  <body >


    <?php echo $__env->make('sweetalert::alert', ['cdn' => "https://cdn.jsdelivr.net/npm/sweetalert2@9"], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    <?php echo $__env->make('frontend.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <?php echo $__env->yieldContent('content'); ?>

    <?php echo $__env->make('frontend.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


    

    <script src="<?php echo e(asset('public/frontend/')); ?>/js/jquery-3.6.3.min.js"></script>
    <script src="<?php echo e(asset('public/frontend/')); ?>/js/slick.min.js"></script>
    <script src="<?php echo e(asset('public/frontend/')); ?>/js/bootstrap.bundle.min.js"></script>
    <script src="<?php echo e(asset('public/frontend/')); ?>/js/custom.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script id="MathJax-script" async src="https://cdn.jsdelivr.net/npm/mathjax@3/es5/tex-mml-chtml.js"></script>

    <?php echo $__env->make('frontend.layouts.js_script', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>


<!--     <script>
        function disableRightClick(event) {
            event.preventDefault();
        }
        document.addEventListener('contextmenu', disableRightClick);
    </script>


    <script>
        // Disable Ctrl+U
        document.addEventListener('keydown', function(event) {
            if (event.ctrlKey && event.key === 'u') {
                event.preventDefault();
            }
        });
    </script> -->

</body>
</html>



<?php /**PATH D:\xampp\htdocs\office\gravity_new\resources\views/frontend/layouts/app.blade.php ENDPATH**/ ?>