
<?php $__env->startSection('head'); ?>

	<title>Start Exam - <?php echo e($site_info->name ?? ''); ?></title>
	<meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>



<div class="container-fluid px-lg-4 px-xl-5 page-wrapper-body">


	<?php echo $__env->make('frontend.user.user_dashboard_sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  
    <section class="student-dashboard-body-section exam-introduction-main-section">
      <div class="container-fluid px-md-5">
        <div class="past-class-body">
          <div class="row g-4">
            <div class="col-md-12">
              <div class="exam-instruction">
                <div class="exam-subject-name current-exam-subject-name text-center">
                    <h2> <?php echo e($exam->name ?? ''); ?> </h2>
                    <h5> <span>Total Question: <?php echo e($exam->total_qs ?? ''); ?></span><span>Full Marks: <?php echo e($exam->total_mark ?? ''); ?></span> <span> Time: <?php echo e($duration ?? $exam->duration); ?> min</span></h5>
                </div>
                <div class="current-exam-time text-center">
                  <p>Remaining:  <span id="timer">0.00</span></p>
                  <p>Start: <?php echo e(Carbon\Carbon::createFromFormat('H:i', $exam->start_time)->format('g:i A')); ?> - <?php echo e(Carbon\Carbon::createFromFormat('H:i', $exam->end_time)->format('g:i A')); ?></p>
              </div>
              </div>
            </div><!-- end col-md-4 -->           
          </div><!-- end row -->


          <form action="<?php echo e(route('user.final_submit_mcq_exam', $exam->id)); ?>" method="post">
            <?php echo csrf_field(); ?>

            <input type="hidden" value="<?php echo e($student_exam_id); ?>" name="student_exam_id" required>

            <?php $__currentLoopData = $questions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="row">
              <div class="col-12">
                <div class="current-exam-question-item">

                  <?php if($item->uddipok): ?>
                  <div class="uddipok">
                    <h4> <?php echo $item->uddipok; ?></h4>
                    <br>
                  </div>
                  <?php endif; ?>

                  <?php if($item->uddipok_img): ?>
                  <div class="uddipok">
                    <h4> <img src="<?php echo e(asset($item->uddipok_img)); ?>" alt=""> </h4>
                    <br>
                  </div>
                  <?php endif; ?>

                  <div class="question">

                    <input type="hidden" name="question_id[]" value="<?php echo e($item->id); ?>">

                    <h5><span>Question <?php echo e($key + 1); ?> :</span> 

                      <?php if($item->question): ?>
                        <?php echo $item->question; ?>

                      <?php endif; ?>

                    </h5>

                    <?php if($item->question_img): ?>

                      <img src="<?php echo e(asset($item->question_img)); ?>" alt="">
                      <br>
                      <br>

                    <?php endif; ?>

                  </div>



                    <div class="answer-option">

                      <input type="radio" id="<?php echo $item->option_one; ?>" name="option[<?php echo e($item->id); ?>]" value="option_one" style="width: 40px;height: 40px; margin-right: 10px;-webkit-border-radius: 50%;-moz-border-radius: 50%;-ms-border-radius: 50%; -o-border-radius: 50%;border: 1px solid gray;font-size: 20px;">


                      <label for="<?php echo $item->option_one; ?>"><?php echo $item->option_one; ?></label><br> <br>


                    </div>



                    <div class="answer-option">

                      <input type="radio" id="<?php echo $item->option_two; ?>" name="option[<?php echo e($item->id); ?>]" value="option_two"  style="width: 40px;height: 40px; margin-right: 10px;-webkit-border-radius: 50%;-moz-border-radius: 50%;-ms-border-radius: 50%; -o-border-radius: 50%;border: 1px solid gray;font-size: 20px;">
                      <label for="<?php echo $item->option_two; ?>"><?php echo $item->option_two; ?></label><br> <br>

                    </div>

                    <div class="answer-option">

                      <input type="radio" id="<?php echo $item->option_three; ?>" name="option[<?php echo e($item->id); ?>]" value="option_three"  style="width: 40px;height: 40px; margin-right: 10px;-webkit-border-radius: 50%;-moz-border-radius: 50%;-ms-border-radius: 50%; -o-border-radius: 50%;border: 1px solid gray;font-size: 20px;">
                      <label for="<?php echo $item->option_three; ?>"><?php echo $item->option_three; ?></label><br> <br>

                    </div>

                    <div class="answer-option">

                      <input type="radio" id="<?php echo $item->option_four; ?>" name="option[<?php echo e($item->id); ?>]" value="option_four"  style="width: 40px;height: 40px; margin-right: 10px;-webkit-border-radius: 50%;-moz-border-radius: 50%;-ms-border-radius: 50%; -o-border-radius: 50%;border: 1px solid gray;font-size: 20px;">
                      <label for="<?php echo $item->option_four; ?>"><?php echo $item->option_four; ?></label><br> <br>

                    </div>




                </div><!-- end question answer item -->
              </div>
            </div><!-- end row --> 
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
     


            <div class="past-class-load-more-btn">
              <button type="submit" style="background: linear-gradient(249deg, #ed0000 0%, #7d07a5 100%) 0% 0% no-repeat padding-box !important;"> Submit</button>
            </div>

          </form>

        </div>
      </div>
    </section>


</div>




    <script>
        // Duration in minutes
        var duration = <?php echo e($duration  ?? $exam->duration); ?>;
        var secondsRemaining = duration * 60;

        function startTimer() {
            var timerDisplay = document.getElementById('timer');

            var timerInterval = setInterval(function() {
                // Calculate minutes and seconds
                var minutes = Math.floor(secondsRemaining / 60);
                var seconds = secondsRemaining % 60;

                // Display the remaining time
                timerDisplay.textContent = minutes + ' minutes ' + seconds + ' seconds';

                // Decrement seconds remaining
                secondsRemaining--;

                // Check if the timer has reached 0
                if (secondsRemaining < 0) {
                    clearInterval(timerInterval);
                    timerDisplay.textContent = 'Time is up!';

                    // Call your URL or perform any action here
                    window.location.href = 'https://example.com';
                }
            }, 1000); // Update every second (1000 milliseconds)
        }

        // Start the timer when the page loads
        window.addEventListener('DOMContentLoaded', startTimer);
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\office\gravity_new\resources\views/frontend/exam/mcq/question_paper.blade.php ENDPATH**/ ?>